Attribute VB_Name = "FEI_const"
'/*-------------------------------------------------------
'|                                                       |
'|                       feusb.h                         |
'|                                                       |
'---------------------------------------------------------
'
'Copyright  2000-2005   FEIG ELECTRONIC GmbH, All Rights Reserved.
'                        Lange Strasse 4
'                        D-35781 Weilburg
'                        Federal Republic of Germany
'                        phone    : +49 6471 31090
'                        fax      : +49 6471 310999
'                        e -mail: info@ feig.de
'                        Internet : http://www.feig.de
'
'Author:                 Markus Hultsch
'Version             :   02.03.02 / 04.07.2005 / M. Hultsch
'
'Operation Systems:      Windows 98 / Me / 2000 / XP
'
'
'This file contains the constants, datatypes and function declartions of FEUSB library
'*/
    
'// FEUSB error codes

'// common errors
Public Const FEUSB_ERR_EMPTY_DEVICELIST = -1100
Public Const FEUSB_ERR_EMPTY_SCANLIST = -1101
Public Const FEUSB_ERR_POINTER_IS_NULL = -1102
Public Const FEUSB_ERR_NO_MORE_MEM = -1103
Public Const FEUSB_ERR_SET_CONFIGURATION = -1104
Public Const FEUSB_ERR_KERNEL = -1105
Public Const FEUSB_ERR_UNSUPPORTED_OPTION = -1106
Public Const FEUSB_ERR_UNSUPPORTED_METHOD = -1107

'// error while scanning
Public Const FEUSB_ERR_NO_FEIG_DEVICE = -1110
Public Const FEUSB_ERR_SEARCH_MISMATCH = -1111
Public Const FEUSB_ERR_NO_DEVICE_FOUND = -1112
Public Const FEUSB_ERR_DEVICE_IS_SCANNED = -1113
Public Const FEUSB_ERR_SCANLIST_OVERFLOW = -1114

'// handle errors
Public Const FEUSB_ERR_UNKNOWN_HND = -1120
Public Const FEUSB_ERR_HND_IS_NULL = -1121
Public Const FEUSB_ERR_HND_IS_NEGATIVE = -1122
Public Const FEUSB_ERR_NO_HND_FOUND = -1123

'// communication errors
Public Const FEUSB_ERR_TIMEOUT = -1130
Public Const FEUSB_ERR_NO_SENDDATA = -1131
Public Const FEUSB_ERR_UNKNOWN_INTERFACE = -1132
Public Const FEUSB_ERR_UNKNOWN_DIRECTION = -1133
Public Const FEUSB_ERR_RECBUF_TOO_SMALL = -1134
Public Const FEUSB_ERR_SENDDATA_LEN = -1135
Public Const FEUSB_ERR_UNKNOWN_DESCRIPTOR_TYPE = -1136
Public Const FEUSB_ERR_DEVICE_NOT_PRESENT = -1137

'// open/close device errors
Public Const FEUSB_ERR_DEVICE_NOT_SCANNED = -1140
Public Const FEUSB_ERR_DEVHND_NOT_IN_SCANLIST = -1141
Public Const FEUSB_ERR_DRIVERLIST = -1142

'// parameter errors
Public Const FEUSB_ERR_UNKNOWN_PARAMETER = -1150
Public Const FEUSB_ERR_PARAMETER_OUT_OF_RANGE = -1151
Public Const FEUSB_ERR_ODD_PARAMETERSTRING = -1152
Public Const FEUSB_ERR_INDEX_OUT_OF_RANGE = -1153
Public Const FEUSB_ERR_UNKNOWN_SCANOPTION = -1154
Public Const FEUSB_ERR_UNKNOWN_ERRORCODE = -1155

'// identification errors
Public Const FEUSB_ERR_DEV_DESC_LENGTH = -1160
Public Const FEUSB_ERR_CFG_DESC_LENGTH = -1161
Public Const FEUSB_ERR_INTF_DESC_LENGTH = -1162
Public Const FEUSB_ERR_ENDP_DESC_LENGTH = -1163
Public Const FEUSB_ERR_HID_DESC_LENGTH = -1164
Public Const FEUSB_ERR_STRG_DESC_LENGTH = -1165
Public Const FEUSB_ERR_READ_DEV_DESCRIPTOR = -1166
Public Const FEUSB_ERR_READ_CFG_DESCRIPTOR = -1167
Public Const FEUSB_ERR_READ_STRG_DESCRIPTOR = -1168

Public Const FEUSB_ERR_MAX_INTERFACES = -1170
Public Const FEUSB_ERR_MAX_ENDPOINTS = -1171
Public Const FEUSB_ERR_MAX_STRINGS = -1172


'// constants for structure _FEUSB_EVENT_INIT

'// defines for uiFlag in FEUSB_EVENT_INIT
Public Const FEUSB_THREAD_ID = 1
Public Const FEUSB_WND_HWND = 2
Public Const FEUSB_CALLBACK = 3

'// defines for uiUse in FEUSB_EVENT_INIT
Public Const FEUSB_DEV_CONNECT_EVENT = 1
Public Const FEUSB_DEV_DISCONNECT_EVENT = 2


'FEISC error codes

'// common errors
Public Const FEISC_ERR_NEWREADER_FAILURE = -4000
Public Const FEISC_ERR_EMPTY_LIST = -4001
Public Const FEISC_ERR_POINTER_IS_NULL = -4002
Public Const FEISC_ERR_NO_MORE_MEM = -4003
Public Const FEISC_ERR_UNKNOWN_COMM_PORT = -4004
Public Const FEISC_ERR_UNSUPPORTED_FUNCTION = -4005
Public Const FEISC_ERR_NO_USB_SUPPORT = -4006
Public Const FEISC_ERR_OLD_FECOM = -4007

'// query errors
Public Const FEISC_ERR_NO_VALUE = -4010

'// handle errors
Public Const FEISC_ERR_UNKNOWN_HND = -4020
Public Const FEISC_ERR_HND_IS_NULL = -4021
Public Const FEISC_ERR_HND_IS_NEGATIVE = -4022
Public Const FEISC_ERR_NO_HND_FOUND = -4023
Public Const FEISC_ERR_PORTHND_IS_NEGATIVE = -4024
Public Const FEISC_ERR_HND_UNVALID = -4025

'// communication errors
Public Const FEISC_ERR_PROTLEN = -4030
Public Const FEISC_ERR_CHECKSUM = -4031
Public Const FEISC_ERR_BUSY_TIMEOUT = -4032
Public Const FEISC_ERR_UNKNOWN_STATUS = -4033
Public Const FEISC_ERR_NO_RECPROTOCOL = -4034
Public Const FEISC_ERR_CMD_BYTE = -4035
Public Const FEISC_ERR_TRANSCEIVE = -4036
Public Const FEISC_ERR_REC_BUS_ADR = -4037

'// parameter errors
Public Const FEISC_ERR_UNKNOWN_PARAMETER = -4050
Public Const FEISC_ERR_PARAMETER_OUT_OF_RANGE = -4051
Public Const FEISC_ERR_ODD_PARAMETERSTRING = -4052
Public Const FEISC_ERR_UNKNOWN_ERRORCODE = -4053
Public Const FEISC_ERR_UNSUPPORTED_OPTION = -4054
Public Const FEISC_ERR_UNKNOWN_EPC_TYPE = -4055

'// plug-in errors
Public Const FEISC_ERR_NO_PLUGIN = -4060
Public Const FEISC_ERR_PLUGIN_PRESENT = -4061
Public Const FEISC_ERR_UNKNOWN_PLUGIN_ID = -4062
Public Const FEISC_ERR_PI_BUILD_DATA = -4063
Public Const FEISC_ERR_PI_BUILD_FRAME = -4064
Public Const FEISC_ERR_PI_SPLIT_FRAME = -4065
Public Const FEISC_ERR_PI_SPLIT_DATA = -4066

'// communication data flow errors
Public Const FEISC_ERR_BUFFER_OVERFLOW = -4070

'// task errors
Public Const FEISC_ERR_TASK_STILL_RUNNING = -4080
Public Const FEISC_ERR_TASK_NOT_STARTED = -4081
Public Const FEISC_ERR_TASK_TIMEOUT = -4082
Public Const FEISC_ERR_TASK_SOCKET_INIT = -4083
Public Const FEISC_ERR_TASK_BUSY = -4084
Public Const FEISC_ERR_THREAD_CANCEL_ERROR = -4085
